"""
GMT logo
========

The :meth:`pygmt.Figure.logo` method allows to place the GMT logo on a figure.
"""

# %%
import pygmt
from pygmt.params import Position

fig = pygmt.Figure()
fig.basemap(region=[0, 10, 0, 2], projection="X6c", frame=True)

# Add the GMT logo in the Top Right (TR) corner of the current plot, scaled up to be 3
# centimeters wide and offset by 0.3 cm in x-direction and 0.6 cm in y-direction.
fig.logo(position=Position("TR", offset=(0.3, 0.6)), width="3c")
fig.show()
